/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.illusivesoulworks.constructsarmory.ConstructsArmoryMod;
import com.james.tinkerscalibration.Utils;
import com.james.tinkerscalibration.effect.LionHeartEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import slimeknights.tconstruct.library.modifiers.impl.TotalArmorLevelModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;

public class ArmorLionHeartModifier
extends TotalArmorLevelModifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> LION = ConstructsArmoryMod.createKey((String)"lion_heart_armor");

    public ArmorLionHeartModifier() {
        super(LION);
        MinecraftForge.EVENT_BUS.addListener(ArmorLionHeartModifier::onHurt);
    }

    private static void onHurt(LivingHurtEvent event) {
        LivingEntity living = event.getEntityLiving();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
            int levels = (Integer)holder.get(LION, (Object)0);
            if (levels > 0 && event.getAmount() > 0.0f) {
                int effectLevel = Math.min(7, ((LionHeartEffect)((Object)((Object)Utils.lionheartEffect.get()))).getLevel(living) + 1);
                ((LionHeartEffect)((Object)((Object)Utils.lionheartEffect.get()))).apply(living, 100, effectLevel, true);
            }
        });
    }
}

